using AllocsFixes.NetConnections.Servers.Telnet;
using System;
using System.Reflection;

namespace AllocsFixes
{
	public class StateManager
	{
		public static void Awake (GameManager manager)
		{
			try {
				Log.Out ("[7dtd-server-fixes by Alloc] Version: " + Assembly.GetExecutingAssembly ().GetName ().Version);

				Mods.LoadMods ();
				Mods.CallGameAwake ();
				CommandExtensions.InitCommandExtensions (manager);

				new Telnet ();

				ItemList.Instance.Init ();

				PersistentData.PersistentContainer.Load ();
			} catch (Exception e) {
				Log.Out ("Error in StateManager.Awake: " + e);
			}
		}

		public static void Shutdown (GameManager manager)
		{
			try {
				Log.Out ("Server shutting down!");
				Mods.CallGameShutdown ();
				PersistentData.PersistentContainer.Instance.Save ();
			} catch (Exception e) {
				Log.Out ("Error in StateManager.Shutdown: " + e);
			}
		}
	}
}

