using System;
using System.Collections.Generic;
using UnityEngine;

namespace AllocsFixes.CustomCommands
{
	public class Give : ConsoleCommand
	{
		public Give (ConsoleSdtd cons) : base(cons)
		{
		}

		public override string Description ()
		{
			return "give an item to a player (entity id or name)";
		}

		public override string[] Names ()
		{
			return new string[] { "give", string.Empty };
		}

		public override void Run (string[] _params)
		{
			try {
				if (_params.Length != 3) {
					m_Console.SendResult ("Usage: give <playername|entityid> <itemname> <amount>");
					return;
				}

				ClientInfo ci = CommonMappingFunctions.GetClientInfoFromNameOrID (_params [0], false);

				if (ci == null) {
					m_Console.SendResult ("Playername or entity id not found.");
					return;
				}

				ItemValue iv = ItemList.Instance.GetItemValue(_params[1]);
				if (iv == null) {
					m_Console.SendResult ("Item not found.");
					return;
				}

				int n = int.MinValue;
				if (!int.TryParse (_params [2], out n) || n <= 0) {
					m_Console.SendResult ("Amount is not an integer or not greater than zero.");
					return;
				}

				EntityPlayer p = CommonMappingFunctions.GetEntityPlayer (ci);

				InventoryField invField = new InventoryField (iv, n);

				CommonMappingFunctions.GetGameManager ().ItemDropServer (invField, p.GetPosition (), Vector3.zero, -1, 50);

				m_Console.SendResult ("Dropped item");
			} catch (Exception e) {
				Log.Out ("Error in Give.Run: " + e);
			}
		}
	}
}
