using AllocsFixes.PersistentData;
using System;
using System.Collections.Generic;

namespace AllocsFixes.CustomCommands
{
	public class ShowInventory : ConsoleCommand
	{
		public ShowInventory (ConsoleSdtd cons) : base(cons)
		{
		}

		public override string Description ()
		{
			return "list inventory of a given player (steam id, entity id or name)";
		}

		public override string[] Names ()
		{
			return new string[] { "showinventory", "si" };
		}

		public override void Run (string[] _params)
		{
			try {
				if (_params.Length < 1) {
					m_Console.SendResult ("Usage: showinventory <steamid|playername|entityid>");
					return;
				}

				string steamid = PersistentContainer.Instance.Players.GetSteamID (_params [0], true);
				if (steamid == null) {
					m_Console.SendResult ("Playername or entity/steamid id not found or no inventory saved (first saved after a player has been online for 30s).");
					return;
				}

				Player p = PersistentContainer.Instance.Players [steamid];
				PersistentData.Inventory inv = p.Inventory;

				m_Console.SendResult ("Belt of player " + p.Name + ":");
				for (int i = 0; i < inv.belt.Count; i++) {
					if (inv.belt [i] != null)
						m_Console.SendResult (string.Format ("    Slot {0}: {1:000} * {2}", i, inv.belt [i].count, inv.belt [i].itemName));
				}
				m_Console.SendResult (string.Empty);
				m_Console.SendResult ("Bagpack of player " + p.Name + ":");
				for (int i = 0; i < inv.bag.Count; i++) {
					if (inv.bag [i] != null)
						m_Console.SendResult (string.Format ("    Slot {0}: {1:000} * {2}", i, inv.bag [i].count, inv.bag [i].itemName));
				}
				m_Console.SendResult (string.Empty);
			} catch (Exception e) {
				Log.Out ("Error in ShowInventory.Run: " + e);
			}
		}
	}
}
