#!/bin/bash

# Print status of given instance.

sdtdCommandStatus() {
	if [ $(isValidInstance $1) -eq 0 ]; then
		echo "No instance given or not a valid instance!"
		return
	fi

	line() {
		printf "    %-*s %s\n" 15 "$1" "$2"
	}
	
	echo "Instance: $1"
	echo

	if [ $(isRunning $1) -eq 1 ]; then
		echo "Status: Running"
		echo "Open ports:"
		netstat -nlp | grep $(getInstancePID $1) | sed -r 's/^([^ ]*)\s+.*[^ :]*:([^ ]*).*[^ :]*:[^ ]*.*/    \2 (\1)/g' | sort
		tel=$(telnetCommand $1 lp)
		cur=`echo $tel | sed "s/\r/\n/g" | sed "s/^ //g" | grep "Total of " | cut -d\  -f 3`
		echo "Players: $cur"
	else
		echo "Status: NOT running"
	fi

	echo
	echo "Game info:"
	line "Server name:" $(getConfigValue $1 ServerName)
	line "Password:" $(getConfigValue $1 ServerPassword)
	line "Max players:" $(getConfigValue $1 ServerMaxPlayerCount)
	line "World:" $(getConfigValue $1 GameWorld)

	echo
	echo "Network info:"
	line "Port:" $(getConfigValue $1 ServerPort)
	line "Public:" $(getConfigValue $1 ServerIsPublic)
	if [ "$(getConfigValue $1 ControlPanelEnabled)" = "false" ]; then
		cp="off"
	else
		cp="Port $(getConfigValue $1 ControlPanelPort), Pass $(getConfigValue $1 ControlPanelPassword)"
	fi
	line "Control Panel:" "$cp"
	if [ "$(getConfigValue $1 TelnetEnabled)" = "false" ]; then
		tn="off"
	else
		tn="Port $(getConfigValue $1 TelnetPort), Pass $(getConfigValue $1 TelnetPassword)"
	fi
	line "Telnet:" "$tn"

	echo
}

sdtdCommandStatusHelp() {
	echo "Usage: $(basename $0) status <instance>"
	echo
	echo "Print status information for the given instance."
}

sdtdCommandStatusDescription() {
	echo "Print status for the given instance"
}

sdtdCommandStatusExpects() {
	case $1 in
		2)
			getInstanceList
			;;
	esac
}

