using System;
using System.Collections.Generic;

namespace AllocsFixes.CustomCommands
{
	public class EnableRendering : ConsoleCmdAbstract
	{
		public override string GetDescription ()
		{
			return "enable/disable live map rendering";
		}

		public override string[] GetCommands ()
		{
			return new string[] { "enablerendering" };
		}

		public override void Execute (List<string> _params, CommandSenderInfo _senderInfo)
		{
			try {
				if (_params.Count != 1) {
					SdtdConsole.Instance.Output ("Current state: " + AllocsFixes.MapRendering.MapRendering.renderingEnabled);
					return;
				}

				AllocsFixes.MapRendering.MapRendering.renderingEnabled = _params[0].Equals("1");
				SdtdConsole.Instance.Output ("Set live map rendering to " + _params [0].Equals ("1"));
			} catch (Exception e) {
				Log.Out ("Error in EnableRendering.Run: " + e);
			}
		}
	}
}