using System;
using System.Collections.Generic;
using UnityEngine;

namespace AllocsFixes.CustomCommands
{
	public class Give : ConsoleCmdAbstract
	{
		public override string GetDescription ()
		{
			return "give an item to a player (entity id or name)";
		}

		public override string[] GetCommands ()
		{
			return new string[] { "give", string.Empty };
		}

		public override void Execute (List<string> _params, CommandSenderInfo _senderInfo)
		{
			try {
				if (_params.Count != 3) {
					SdtdConsole.Instance.Output ("Usage: give <playername|entityid> <itemname> <amount>");
					return;
				}

				ClientInfo ci = ConsoleHelper.ParseParamIdOrName (_params [0]);

				if (ci == null) {
					SdtdConsole.Instance.Output ("Playername or entity id not found.");
					return;
				}

				ItemValue iv = ItemList.Instance.GetItemValue (_params[1]);
				if (iv == null) {
					SdtdConsole.Instance.Output ("Item not found.");
					return;
				}

				int n = int.MinValue;
				if (!int.TryParse (_params [2], out n) || n <= 0) {
					SdtdConsole.Instance.Output ("Amount is not an integer or not greater than zero.");
					return;
				}

				EntityPlayer p = GameManager.Instance.World.Players.dict [ci.entityId];

				InventoryField invField = new InventoryField (iv, n);

				GameManager.Instance.ItemDropServer (invField, p.GetPosition (), Vector3.zero, -1, 50);

				SdtdConsole.Instance.Output ("Dropped item");
			} catch (Exception e) {
				Log.Out ("Error in Give.Run: " + e);
			}
		}
	}
}
