using AllocsFixes.PersistentData;
using System;
using System.Collections.Generic;
using UnityEngine;

namespace AllocsFixes
{
	public class AllocsLogFunctions
	{
		public static void RequestToSpawnPlayer (int _clientId, string _name, int _chunkViewDim, PlayerProfile _playerProfile)
		{
			try {
				ClientInfo ci = ConnectionManager.Instance.GetClient (_clientId);

				Log.Out ("Player connected, clientid=" + _clientId +
					", entityid=" + ci.entityId +
					", name=" + ci.playerName +
					", steamid=" + ci.playerId +
					", ip=" + ci.ip
				);

				PersistentContainer.Instance.Players [ci.playerId].SetOnline (ci);
				PersistentData.PersistentContainer.Instance.Save ();
			} catch (Exception e) {
				Log.Out ("Error in AllocsLogFunctions.RequestToSpawnPlayer: " + e);
			}
		}

		public static void PlayerDisconnected (ClientInfo _cInfo, bool _bShutdown)
		{
			try {
				Player p = PersistentContainer.Instance.Players [_cInfo.playerId];
				if (p != null) {
					p.SetOffline ();
				} else {
					Log.Out ("Disconnected player not found in client list...");
				}
				PersistentData.PersistentContainer.Instance.Save ();
			} catch (Exception e) {
				Log.Out ("Error in AllocsLogFunctions.PlayerDisconnected: " + e);
			}
		}
	}
}
