using AllocsFixes.MapRendering;
using System;
using System.IO;
using System.Collections.Generic;

namespace AllocsFixes.CustomCommands
{
	public class RenderMap : ConsoleCmdAbstract
	{
		public override string GetDescription ()
		{
			return "render the current map to a file";
		}

		public override string[] GetCommands ()
		{
			return new string[] { "rendermap" };
		}

		public override void Execute (List<string> _params, CommandSenderInfo _senderInfo)
		{
			try {
				AllocsFixes.MapRendering.MapRendering.Instance.RenderFullMap ();

				SdtdConsole.Instance.Output ("Render map done");
			} catch (Exception e) {
				Log.Out ("Error in RenderMap.Run: " + e);
			}
		}
	}
}
