using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using System.Threading;

namespace AllocsFixes.PersistentData
{
	[Serializable]
	public class Inventory
	{
		public List<InvItem> bag;
		public List<InvItem> belt;

		public Inventory ()
		{
			bag = new List<InvItem> ();
			belt = new List<InvItem> ();
		}

		public void Update (PlayerDataFile pdf)
		{
			//Log.Out ("Updating player inventory - player id: " + pdf.id);
			ProcessInv (bag, pdf.bag, pdf.id);
			ProcessInv (belt, pdf.inventory, pdf.id);
		}

		private void ProcessInv (List<InvItem> target, ItemStack[] sourceFields, int id)
		{
			lock (target) {
				target.Clear ();
				for (int i = 0; i < sourceFields.Length; i++) {
					if (sourceFields [i].count > 0) {
						int count = sourceFields [i].count;
						int maxAllowed = ItemClass.list [sourceFields [i].itemValue.type].Stacknumber.Value;
						string name = ItemClass.list [sourceFields [i].itemValue.type].GetItemName ();

						if (count > maxAllowed)
							Log.Out ("Player with ID " + id + " has stack for \"" + name + "\" greater than allowed (" + count + " > " + maxAllowed + ")");
						target.Add (new InvItem (name, count));
					} else {
						target.Add (null);
					}
				}
			}
		}


	}
}

