using System;

namespace AllocsFixes
{
	public class ChatHookExample {
		private const string BBFILTER = "[ffffffff][/url][/b][/i][/u][/s][/sub][/sup][ff]";
		private const string ANSWER = "     [ff0000]I[-] [ff7f00]W[-][ffff00]A[-][80ff00]S[-] [00ffff]H[-][0080ff]E[-][0000ff]R[-][8b00ff]E[-]";

		public static bool Hook (ClientInfo _cInfo, string _message, string _playerName) {
			if (!string.IsNullOrEmpty (_message)) {
				if (_message.EndsWith (BBFILTER + BBFILTER)) {
					_message = _message.Remove (_message.Length - 2 * BBFILTER.Length);
				}

				if (_message.ToLower () == "/alloc") {
					if (_cInfo != null) {
						Log.Out ("Sent chat hook reply to {0}", _cInfo.playerId);
						_cInfo.SendPackage (new NetPackageGameMessage (ANSWER, ""));
					} else {
						Log.Error ("Argument _cInfo null on message: {0}", _message);
					}
					return false;
				}
			}

			return true;
		}

	}
}
