L.Control.ReloadTiles = L.Control.extend({
	options: {
		position: 'bottomleft',
		layers: []
	},

	onAdd: function (map) {
		var name = 'control-reloadtiles',
		    container = L.DomUtil.create('div', name + ' webmap-control');

		L.DomEvent.on (container, 'mousemove', L.DomEvent.stopPropagation);

		this._map = map;

		this._reloadbutton = this._createButton(
			"Reload tiles", "Reload tiles",
			name + "-btn", container, this._reload, this);

		return container;
	},

	onRemove: function (map) {
	},

	_reload: function (e) {
		var newTileTime = new Date().getTime();
		
		for (var i = 0; i < this.options.layers.length; i++) {
			this.options.layers [i].options.time = newTileTime;
			this.options.layers [i].redraw ();
		}
	},

	_createButton: function (html, title, className, container, fn, context) {
		var link = L.DomUtil.create('a', className, container);
		link.innerHTML = html;
		link.href = '#';
		link.title = title;

		var stop = L.DomEvent.stopPropagation;

		L.DomEvent
		    .on(link, 'click', stop)
		    .on(link, 'mousedown', stop)
		    .on(link, 'dblclick', stop)
		    .on(link, 'click', L.DomEvent.preventDefault)
		    .on(link, 'click', fn, context)
		    .on(link, 'click', this._refocusOnMap, context);
		   
		return link;
	}

});

