using System;
using System.Net;
using System.Text;

namespace AllocsFixes.NetConnections.Servers.Web.API
{
	public abstract class WebAPI
	{
		public void WriteJSON (HttpListenerResponse resp, JSON.JSONNode root)
		{
			byte[] buf = Encoding.UTF8.GetBytes (root.ToString());
			resp.ContentLength64 = buf.Length;
			resp.ContentType = "application/json";
			resp.ContentEncoding = Encoding.UTF8;
			resp.OutputStream.Write (buf, 0, buf.Length);
		}

		public abstract void HandleRequest (HttpListenerRequest req, HttpListenerResponse resp, WebConnection user, int permissionLevel);
	}
}

