using AllocsFixes.JSON;
using AllocsFixes.PersistentData;
using System;
using System.Collections.Generic;
using System.Net;

namespace AllocsFixes.NetConnections.Servers.Web.API
{
	public class GetPlayersLocation : WebAPI
	{
		public override void HandleRequest (HttpListenerRequest req, HttpListenerResponse resp, WebConnection user, int permissionLevel)
		{
			JSONArray playersJsResult = new JSONArray ();

			Players playersList = PersistentContainer.Instance.Players;

			foreach (string sid in playersList.SteamIDs) {
				Player p = playersList[sid, false];

				JSONObject pos = new JSONObject();
				pos.Add("x", new JSONNumber(p.LastPosition.x));
				pos.Add("y", new JSONNumber(p.LastPosition.y));
				pos.Add("z", new JSONNumber(p.LastPosition.z));

				JSONObject pJson = new JSONObject();
				pJson.Add("steamid", new JSONString(sid));
				pJson.Add("ip", new JSONString(p.IP));
				pJson.Add("name", new JSONString(p.Name));
				pJson.Add("online", new JSONBoolean(p.IsOnline));
				pJson.Add("position", pos);

				playersJsResult.Add(pJson);
			}

			WriteJSON(resp, playersJsResult);
		}
	}
}

