using System;
using System.Collections.Generic;

using UnityEngine;

namespace AllocsFixes.NetConnections.Servers.Web
{
	public class WebConnection : ConsoleConnectionAbstract {
		private string sessionId;
		private string endpoint;
		private ulong steamId;
		private DateTime login;
		private DateTime lastAction;

		private List<string> outputLines = new List<string> ();
		private List<LogLine> logLines = new List<LogLine> ();

		public string SessionID {
			get { return sessionId; }
		}

		public string Endpoint {
			get { return endpoint; }
		}

		public ulong SteamID {
			get { return steamId; }
		}

		public TimeSpan Age {
			get { return DateTime.Now - lastAction; }
		}

		public WebConnection (string _sessionId, string _endpoint, ulong _steamId) {
			this.sessionId = _sessionId;
			this.endpoint = _endpoint;
			this.steamId = _steamId;
			this.login = DateTime.Now;
			this.lastAction = this.login;
		}

		public void UpdateUsage () {
			this.lastAction = DateTime.Now;
		}

		public override string GetDescription () {
			return "WebPanel from " + endpoint;
		}

		public override void SendLine (string _text) {
			outputLines.Add (_text);
		}

		public override void SendLines (List<string> _output) {
			outputLines.AddRange (_output);
		}

		public override void SendLog (string _msg, string _trace, LogType _type) {
			LogLine ll = new LogLine ();
			ll.message = _msg;
			ll.trace = _trace;
			ll.type = _type;
			logLines.Add (ll);
		}

		private struct LogLine {
			public string message;
			public string trace;
			public LogType type;
		}
	}
}

