using System;
using System.Collections.Generic;

namespace AllocsFixes.CustomCommands
{
	public class ReloadWebPermissions : ConsoleCmdAbstract
	{
		public override string GetDescription ()
		{
			return "force reload of web permissions file";
		}

		public override string[] GetCommands ()
		{
			return new string[] { "reloadwebpermissions" };
		}

		public override void Execute (List<string> _params, CommandSenderInfo _senderInfo)
		{
			try {
				AllocsFixes.NetConnections.Servers.Web.WebPermissions.Instance.Load ();
				SdtdConsole.Instance.Output ("Web permissions file reloaded");
			} catch (Exception e) {
				Log.Out ("Error in ReloadWebPermissions.Run: " + e);
			}
		}
	}
}