function GetRegionLayer (mapinfo) {
	var FormatRegionFileName = function(latlng) {
		return "r." + latlng.lat + "." + latlng.lng + ".7rg";
	}

	var regionLayer = L.tileLayer.canvas({
		maxZoom: mapinfo.maxzoom + 1,
		minZoom: 0,
		maxNativeZoom: mapinfo.maxzoom + 1,
		tileSize: mapinfo.tilesize,
		continuousWorld: true
	});

	regionLayer.drawTile = function(canvas, tilePoint, zoom) {
		var blockWorldSize = mapinfo.tilesize * Math.pow(2, mapinfo.maxzoom - zoom);
		var tileLeft = tilePoint.x * blockWorldSize;
		var tileBottom = (-1-tilePoint.y) * blockWorldSize;
		var blockPos = L.latLng(tileLeft, tileBottom);

		var ctx = canvas.getContext('2d');

		ctx.strokeStyle = "lightblue";
		ctx.fillStyle = "lightblue";
		ctx.lineWidth = 1;
		ctx.font="14px Arial";

		var lineCount = blockWorldSize / mapinfo.regionsize;
		if (lineCount >= 1) {
			var pos = 0;
			while (pos < mapinfo.tilesize) {
				// Vertical
				ctx.beginPath();
				ctx.moveTo(pos, 0);
				ctx.lineTo(pos, mapinfo.tilesize);
				ctx.stroke();
		
				// Horizontal
				ctx.beginPath();
				ctx.moveTo(0, pos);
				ctx.lineTo(mapinfo.tilesize, pos);
				ctx.stroke();

				pos += mapinfo.tilesize / lineCount;
			}
			ctx.fillText(FormatRegionFileName(CoordToRegion(blockPos)), 4, mapinfo.tilesize-5);
		} else {
			if ((tileLeft % mapinfo.regionsize) == 0) {
				// Vertical
				ctx.beginPath();
				ctx.moveTo(0, 0);
				ctx.lineTo(0, mapinfo.tilesize);
				ctx.stroke();
			}
			if ((tileBottom % mapinfo.regionsize) == 0) {
				// Horizontal
				ctx.beginPath();
				ctx.moveTo(0, mapinfo.tilesize);
				ctx.lineTo(mapinfo.tilesize, mapinfo.tilesize);
				ctx.stroke();
			}
			if ((tileLeft % mapinfo.regionsize) == 0 && (tileBottom % mapinfo.regionsize) == 0) {
				ctx.fillText(FormatRegionFileName(CoordToRegion(blockPos)), 4, mapinfo.tilesize-5);
			}
		}

	}
	
	return regionLayer;
}

