using AllocsFixes.JSON;
using AllocsFixes.PersistentData;
using System;
using System.Collections.Generic;
using System.Net;

namespace AllocsFixes.NetConnections.Servers.Web.API
{
	public class ExecuteConsoleCommand : WebAPI
	{
		public override void HandleRequest (HttpListenerRequest req, HttpListenerResponse resp, WebConnection user, int permissionLevel) {
			if (string.IsNullOrEmpty (req.QueryString ["command"])) {
				resp.StatusCode = (int)HttpStatusCode.BadRequest;
				Web.SetResponseTextContent (resp, "No command given");
				return;
			}

			string commandName = req.QueryString ["command"];

			IConsoleCommand command = SdtdConsole.Instance.GetCommand (commandName);

			if (command == null) {
				resp.StatusCode = (int)HttpStatusCode.NotImplemented;
				Web.SetResponseTextContent (resp, "Unknown command");
				return;
			}

			AdminToolsCommandPermissions atcp = GameManager.Instance.adminTools.GetAdminToolsCommandPermission (command.GetCommands ());

			if (permissionLevel > atcp.PermissionLevel) {
				resp.StatusCode = (int)HttpStatusCode.Forbidden;
				Web.SetResponseTextContent (resp, "You are not allowed to execute this command");
				return;
			}

			// TODO: Execute command (store resp as IConsoleConnection instance to deliver response to the single client?)

//			JSONObject result = new JSONObject ();
//			result.Add ("claimsize", new JSONNumber (GamePrefs.GetInt (EnumGamePrefs.LandClaimSize)));
//
//			JSONArray claimOwners = new JSONArray ();
//			result.Add ("claimowners", claimOwners);
//
//			Dictionary<Vector3i, PersistentPlayerData> d = GameManager.Instance.GetPersistentPlayerList ().m_lpBlockMap;
//			if (d != null) {
//				World w = GameManager.Instance.World;
//				Dictionary<PersistentPlayerData, List<Vector3i>> owners = new Dictionary<PersistentPlayerData, List<Vector3i>> ();
//				foreach (KeyValuePair<Vector3i, PersistentPlayerData> kvp in d) {
//					if (steamid.Length == 0 || kvp.Value.PlayerId.Equals (steamid)) {
//						if (!owners.ContainsKey (kvp.Value)) {
//							owners.Add (kvp.Value, new List<Vector3i> ());
//						}
//						owners [kvp.Value].Add (kvp.Key);
//					}
//				}
//
//				foreach (KeyValuePair<PersistentPlayerData, List<Vector3i>> kvp in owners) {
//					if (steamid.Length == 0 || kvp.Key.PlayerId.Equals (steamid)) {
//						string curID = kvp.Key.PlayerId;
//						bool isActive = w.IsLandProtectionValidForPlayer (kvp.Key);
//
//						JSONObject owner = new JSONObject ();
//						claimOwners.Add (owner);
//
//						owner.Add ("steamid", new JSONString (curID));
//						owner.Add ("claimactive", new JSONBoolean (isActive));
//
//						JSONArray claims = new JSONArray ();
//						owner.Add ("claims", claims);
//
//						foreach (Vector3i v in kvp.Value) {
//							JSONObject claim = new JSONObject ();
//							claim.Add ("x", new JSONNumber (v.x));
//							claim.Add ("y", new JSONNumber (v.y));
//							claim.Add ("z", new JSONNumber (v.z));
//
//							claims.Add (claim);
//						}
//					}
//				}
//			}
//
//			WriteJSON (resp, result);
		}
	}
}

