using AllocsFixes.JSON;
using AllocsFixes.PersistentData;
using System;
using System.Collections.Generic;
using System.Net;

namespace AllocsFixes.NetConnections.Servers.Web.API
{
	public class GetPlayerInventory : WebAPI {
		public override void HandleRequest (HttpListenerRequest req, HttpListenerResponse resp, WebConnection user, int permissionLevel) {
			if (req.QueryString ["steamid"] == null) {
				resp.StatusCode = (int)HttpStatusCode.InternalServerError;
				Web.SetResponseTextContent (resp, "No SteamID given");
				return;
			}

			Player p = PersistentContainer.Instance.Players [req.QueryString ["steamid"], false];
			if (p == null) {
				resp.StatusCode = (int)HttpStatusCode.InternalServerError;
				Web.SetResponseTextContent (resp, "Invalid or unknown SteamID given");
				return;
			}

			PersistentData.Inventory inv = p.Inventory;


			JSONObject result = new JSONObject ();

			JSONArray bag = new JSONArray ();
			JSONArray belt = new JSONArray ();
			JSONObject equipment = new JSONObject ();
			result.Add ("playername", new JSONString (p.Name));
			result.Add ("bag", bag);
			result.Add ("belt", belt);
			result.Add ("equipment", equipment);

			for (int i = 0; i < inv.belt.Count; i++) {
				JSONObject item = new JSONObject ();
				if (inv.belt [i] != null) {
					item.Add ("count", new JSONNumber (inv.belt [i].count));
					item.Add ("name", new JSONString (inv.belt [i].itemName));
				} else {
					item.Add ("count", new JSONNumber (0));
					item.Add ("name", new JSONString (string.Empty));
				}
				belt.Add (item);
			}
			for (int i = 0; i < inv.bag.Count; i++) {
				JSONObject item = new JSONObject ();
				if (inv.bag [i] != null) {
					item.Add ("count", new JSONNumber (inv.bag [i].count));
					item.Add ("name", new JSONString (inv.bag [i].itemName));
				} else {
					item.Add ("count", new JSONNumber (0));
					item.Add ("name", new JSONString (string.Empty));
				}
				bag.Add (item);
			}

			AddEquipment (equipment, "head", inv.equipment, XMLData.Item.EnumEquipmentSlot.Head, NGuiInvGridEquipment.EnumClothingLayer.Middle);
			AddEquipment (equipment, "eyes", inv.equipment, XMLData.Item.EnumEquipmentSlot.Eyes, NGuiInvGridEquipment.EnumClothingLayer.Middle);
			AddEquipment (equipment, "face", inv.equipment, XMLData.Item.EnumEquipmentSlot.Face, NGuiInvGridEquipment.EnumClothingLayer.Middle);

			AddEquipment (equipment, "armor", inv.equipment, XMLData.Item.EnumEquipmentSlot.Chest, NGuiInvGridEquipment.EnumClothingLayer.Outer);
			AddEquipment (equipment, "jacket", inv.equipment, XMLData.Item.EnumEquipmentSlot.Chest, NGuiInvGridEquipment.EnumClothingLayer.Middle);
			AddEquipment (equipment, "shirt", inv.equipment, XMLData.Item.EnumEquipmentSlot.Chest, NGuiInvGridEquipment.EnumClothingLayer.Inner);

			AddEquipment (equipment, "legarmor", inv.equipment, XMLData.Item.EnumEquipmentSlot.Legs, NGuiInvGridEquipment.EnumClothingLayer.Outer);
			AddEquipment (equipment, "pants", inv.equipment, XMLData.Item.EnumEquipmentSlot.Legs, NGuiInvGridEquipment.EnumClothingLayer.Inner);
			AddEquipment (equipment, "boots", inv.equipment, XMLData.Item.EnumEquipmentSlot.Feet, NGuiInvGridEquipment.EnumClothingLayer.Inner);

			AddEquipment (equipment, "gloves", inv.equipment, XMLData.Item.EnumEquipmentSlot.Hands, NGuiInvGridEquipment.EnumClothingLayer.Inner);
			AddEquipment (equipment, "backpack", inv.equipment, XMLData.Item.EnumEquipmentSlot.Back, NGuiInvGridEquipment.EnumClothingLayer.Outer);

			WriteJSON (resp, result);
		}

		private void AddEquipment (JSONObject _eq, string _slotname, InvItem[] _items, XMLData.Item.EnumEquipmentSlot _slot, NGuiInvGridEquipment.EnumClothingLayer _layer) {
			int index = (int)_slot + (int)_layer * (int)XMLData.Item.EnumEquipmentSlot.Count;
			if (_items != null && _items [index] != null) {
				_eq.Add (_slotname, new JSONString (_items [index].itemName));
			} else {
				_eq.Add (_slotname, new JSONBoolean (false));
			}
		}

	}
}

