using System;
using System.Collections.Generic;

namespace AllocsFixes.NetConnections.Servers.Web
{
	public class ConnectionHandler {
		private Web parent;
		private Dictionary<string, WebConnection> connections = new Dictionary<string, WebConnection> ();

		public ConnectionHandler (Web _parent) {
			parent = _parent;
		}

		public WebConnection IsLoggedIn (string _sessionId, string _endpoint) {
			if (!connections.ContainsKey (_sessionId)) {
				return null;
			}

			WebConnection con = connections [_sessionId];
//			if (con.Age.TotalMinutes > parent.sessionTimeoutMinutes) {
//				connections.Remove (_sessionId);
//				return null;
//			}

			if (con.Endpoint != _endpoint) {
				connections.Remove (_sessionId);
				return null;
			}

			con.UpdateUsage ();

			return con;
		}

		public void LogOut (string _sessionId) {
			connections.Remove (_sessionId);
		}

		public WebConnection LogIn (ulong _steamId, string _endpoint) {
			string sessionId = Guid.NewGuid ().ToString ();
			WebConnection con = new WebConnection (sessionId, _endpoint, _steamId);
			connections.Add (sessionId, con);
			return con;
		}

		public void SendLine (string line) {
			foreach (WebConnection wc in connections.Values) {
				wc.SendLine (line);
			}
		}

	}
}

