﻿using AllocsFixes.JSON;
using AllocsFixes.LiveData;
using System;
using System.Collections.Generic;
using System.Net;

namespace AllocsFixes.NetConnections.Servers.Web.API
{
    class GetAnimalsLocation : WebAPI
    {
        public override void HandleRequest(HttpListenerRequest req, HttpListenerResponse resp, WebConnection user, int permissionLevel)
        {
            JSONArray animalsJsResult = new JSONArray();

            foreach (EntityAnimal entity in Animals.List)
            {
                Vector3i position = new Vector3i(entity.GetPosition());

                JSONObject jsonPOS = new JSONObject();
                jsonPOS.Add("x", new JSONNumber(position.x));
                jsonPOS.Add("y", new JSONNumber(position.y));
                jsonPOS.Add("z", new JSONNumber(position.z));

                JSONObject pJson = new JSONObject();
                pJson.Add("id", new JSONNumber(entity.entityId));

                if (!string.IsNullOrEmpty(entity.EntityName))
                    pJson.Add("name", new JSONString(entity.EntityName));
                else
                    pJson.Add("name", new JSONString("animal class #" + entity.entityClass.ToString()));

                pJson.Add("position", jsonPOS);

                animalsJsResult.Add(pJson);
            }
            
            WriteJSON(resp, animalsJsResult);
        }
    }
}
