﻿using AllocsFixes.JSON;
using System;
using System.Collections.Generic;
using System.Net;

namespace AllocsFixes.NetConnections.Servers.Web.API
{
    class GetRawEntitiesList : WebAPI
    {
        public override void HandleRequest (HttpListenerRequest req, HttpListenerResponse resp, WebConnection user, int permissionLevel)
        {
            JSONArray entitiesJsResult = new JSONArray ();

            // Yes: hardcoded... even hacking the web interface won't show this data.  You -must- be an admin.
            if (permissionLevel != 0) {
                try {
                    foreach (object base_entity in GameManager.Instance.World.Entities.list) {
                        try {
                            Entity entity = (Entity)base_entity;

                            if ((entity.entityType == EntityType.Animal) || (base_entity.GetType () == typeof(EntityAnimal)) || (base_entity.GetType ().ToString ().ToLower ().Contains ("animal")))
                            {
                                EntityAnimal ea = (EntityAnimal)entity;

                                Vector3i position = new Vector3i (entity.GetPosition ());

                                JSONObject jsonPOS = new JSONObject ();
                                jsonPOS.Add("x", new JSONNumber (position.x));
                                jsonPOS.Add("y", new JSONNumber (position.y));
                                jsonPOS.Add("z", new JSONNumber (position.z));

                                JSONObject pJson = new JSONObject ();
                                pJson.Add ("id", new JSONNumber (entity.entityId));
                                pJson.Add ("type", new JSONString ("animal"));
                                pJson.Add ("tag", new JSONString (entity.tag ?? ""));
                                pJson.Add ("model", new JSONString ((entity.emodel == null) ? "?" : entity.emodel.name ?? "?"));
                                pJson.Add ("alive", new JSONBoolean (ea.IsAlive ()));
                                pJson.Add ("health", new JSONNumber (ea.Health));

                                if (PetesUtils.ValidText (ea.EntityName))
                                    pJson.Add ("name", new JSONString (ea.EntityName));
                                else
                                    pJson.Add ("name", new JSONString ("animal class #" + entity.entityClass.ToString ()));

                                pJson.Add ("position", jsonPOS);

                                entitiesJsResult.Add (pJson);
                            }
                            else if ((entity.entityType == EntityType.Zombie) || (base_entity.GetType () == typeof(EntityEnemy))) {
                                EntityEnemy ee = (EntityEnemy)entity;

                                Vector3i position = new Vector3i (entity.GetPosition ());

                                JSONObject jsonPOS = new JSONObject ();
                                jsonPOS.Add ("x", new JSONNumber (position.x));
                                jsonPOS.Add ("y", new JSONNumber (position.y));
                                jsonPOS.Add ("z", new JSONNumber (position.z));

                                JSONObject pJson = new JSONObject ();
                                pJson.Add ("id", new JSONNumber (entity.entityId));
                                pJson.Add ("type", new JSONString ("enemy"));
                                pJson.Add ("tag", new JSONString (entity.tag ?? ""));
                                pJson.Add ("model", new JSONString ((entity.emodel == null) ? "?" : entity.emodel.name ?? "?"));
                                pJson.Add ("alive", new JSONBoolean (ee.IsAlive ()));
                                pJson.Add ("health", new JSONNumber (ee.Health));

                                if (PetesUtils.ValidText (ee.EntityName))
                                    pJson.Add ("name", new JSONString (ee.EntityName));
                                else
                                    pJson.Add ("name", new JSONString ("enemy class #" + entity.entityClass.ToString ()));

                                pJson.Add ("position", jsonPOS);

                                entitiesJsResult.Add (pJson);
                            }
                            else if ((entity.entityType == EntityType.Player) || (base_entity.GetType () == typeof(EntityPlayer))) {
                                EntityPlayer ep = (EntityPlayer)entity;

                                Vector3i position = new Vector3i (entity.GetPosition ());

                                JSONObject jsonPOS = new JSONObject ();
                                jsonPOS.Add ("x", new JSONNumber (position.x));
                                jsonPOS.Add ("y", new JSONNumber (position.y));
                                jsonPOS.Add ("z", new JSONNumber (position.z));

                                JSONObject pJson = new JSONObject ();
                                pJson.Add ("id", new JSONNumber (entity.entityId));
                                pJson.Add ("type", new JSONString ("player"));
                                pJson.Add ("tag", new JSONString (entity.tag ?? ""));
                                pJson.Add ("model", new JSONString ((entity.emodel == null) ? "?" : entity.emodel.name ?? "?"));
                                pJson.Add ("alive", new JSONBoolean (ep.IsAlive ()));
                                pJson.Add ("score", new JSONNumber (ep.Score));
                                pJson.Add ("health", new JSONNumber (ep.Health));
                                pJson.Add ("zombiekills", new JSONNumber (ep.KilledZombies));
                                pJson.Add ("stamina", new JSONNumber (ep.Stamina));

                                if (PetesUtils.ValidText (ep.EntityName))
                                    pJson.Add ("name", new JSONString (ep.EntityName));
                                else
                                    pJson.Add ("name", new JSONString ("player class #" + entity.entityClass.ToString ()));

                                pJson.Add("position", jsonPOS);

                                entitiesJsResult.Add(pJson);
                            }
                            else { // note: animals are an EntityAnimal but are being generated with the wrong entityType ID, so get caught here
                                Vector3i position = new Vector3i (entity.GetPosition ());

                                JSONObject jsonPOS = new JSONObject ();
                                jsonPOS.Add ("x", new JSONNumber (position.x));
                                jsonPOS.Add ("y", new JSONNumber (position.y));
                                jsonPOS.Add ("z", new JSONNumber (position.z));

                                JSONObject pJson = new JSONObject ();
                                pJson.Add ("id", new JSONNumber (entity.entityId));
                                pJson.Add ("type", new JSONString ("unknown #" + ((int)entity.entityType).ToString ()));
                                pJson.Add ("tag", new JSONString (entity.tag ?? ""));

                                string true_name = entity.name;
                                
                                try {
                                    int iTries = 0;
                                    UnityEngine.GameObject go = entity.gameObject;

                                    while (true_name == "GameObject") {
                                        true_name = go.name;
                                        go = go.gameObject;

                                        if (++iTries > 10)
                                            break;
                                    }
                                }
                                catch { }

                                string true_emodel = (entity.emodel == null) ? "?" : entity.emodel.name;

                                try {
                                    int iTries = 0;
                                    UnityEngine.GameObject go = entity.emodel.gameObject;

                                    while (true_emodel == "GameObject") {
                                        true_emodel = go.name;
                                        go = go.gameObject;

                                        if (++iTries > 10)
                                            break;
                                    }
                                }
                                catch { }

                                pJson.Add ("model", new JSONString (true_emodel));

                                if (PetesUtils.ValidText (true_name))
                                    pJson.Add("name", new JSONString (base_entity.GetType ().ToString () + ": " + true_name));
                                else
                                    pJson.Add("name", new JSONString (base_entity.GetType ().ToString () + " class #" + entity.entityClass.ToString ()));

                                pJson.Add ("position", jsonPOS);

                                entitiesJsResult.Add (pJson);
                            }
                        }
                        catch { }
                    }
                }
                catch (Exception ex) {
                    entitiesJsResult.Add (new JSONString ("Error: " + ex.GetType ().ToString () + " - " + ex.Message + "\r\n" + ex.StackTrace));
                }
            }

            WriteJSON (resp, entitiesJsResult);
        }
    }
}
