using AllocsFixes.JSON;
using AllocsFixes.PersistentData;
using System;
using System.Collections.Generic;
using System.Net;

namespace AllocsFixes.NetConnections.Servers.Web.API
{
	public class GetPlayersLocation : WebAPI
	{
		public override void HandleRequest (HttpListenerRequest req, HttpListenerResponse resp, WebConnection user, int permissionLevel)
		{
            AdminTools admTools = null;

            try { admTools = GameManager.Instance.adminTools; } catch { }
            try { user = user ?? new WebConnection ("", "", 0L); } catch { } // default user, cheap way to avoid 'null reference exception'

            bool bViewAll = false; try { bViewAll = user.CanViewAllPlayers (permissionLevel); } catch { }

            JSONArray playersJsResult = new JSONArray ();

			Players playersList = PersistentContainer.Instance.Players;

			foreach (string sid in playersList.SteamIDs) {
                try {
                    if ((admTools != null) && (PetesUtils.ValidText (sid)))
                        if (admTools.IsBanned (sid))
                            continue;
                }
                catch { }

                try
                {
                    Player p = playersList [sid, false];

                    ulong player_steam_ID = 0L;
                    if (!ulong.TryParse (sid, out player_steam_ID))
                        player_steam_ID = 0L;

                    if ((player_steam_ID == user.SteamID) || bViewAll) {
                        JSONObject pos = new JSONObject ();
                        pos.Add("x", new JSONNumber (p.LastPosition.x));
                        pos.Add("y", new JSONNumber (p.LastPosition.y));
                        pos.Add("z", new JSONNumber (p.LastPosition.z));

                        JSONObject pJson = new JSONObject ();
                        pJson.Add("steamid", new JSONString (sid));
                        pJson.Add("ip", new JSONString (p.IP));
                        pJson.Add("name", new JSONString (p.Name));
                        pJson.Add("online", new JSONBoolean (p.IsOnline));
                        pJson.Add("position", pos);

                        playersJsResult.Add (pJson);
                    }
                }
                catch { }
            }

			WriteJSON (resp, playersJsResult);
		}
	}
}

