﻿using System;
using System.IO;
using System.Drawing;
using System.Drawing.Imaging;

namespace AllocsFixes
{
    public static class PetesUtils {
        public static bool ValidText(object oText) {
            if (oText == null)
                return false;

            if (oText.GetType () == typeof (string)) {
                if (((string)oText).Trim ().Length < 1)
                    return false;

                return true;
            }

            if (oText.ToString ().Trim ().Length < 1)
                return false;

            return true;
        }

        // Note: don't forget to dispose the image (which also disposes the underlying stream) when done with the image.
        public static System.Drawing.Image GetImageFromBytes(byte[] bImage) {
            if ((bImage == null) || (bImage.Length == 0))
                return null;

            try {
                MemoryStream ms = new MemoryStream ();
                ms.Write (bImage, 0, bImage.Length);
                ms.Seek (0, SeekOrigin.Begin);
                Image i = Image.FromStream (ms);
                return i;
            }
            catch { }

            return null;
        }

        /*
        public static System.Drawing.Color BlendColors(System.Drawing.Color color, System.Drawing.Color backColor, double amount) {
            byte r = (byte)((color.R * amount) + backColor.R * (1 - amount));
            byte g = (byte)((color.G * amount) + backColor.G * (1 - amount));
            byte b = (byte)((color.B * amount) + backColor.B * (1 - amount));
            return System.Drawing.Color.FromArgb (r, g, b);
        }
        */

        /*
        public static System.Drawing.Color FromAhsb (int alpha, float hue, float saturation, float brightness)
        {
            if (0 > alpha || 255 < alpha) {
                throw new ArgumentOutOfRangeException ("alpha", alpha, "Value must be within a range of 0 - 255.");
            }

            if (0f > hue || 360f < hue) {
                throw new ArgumentOutOfRangeException ("hue", hue, "Value must be within a range of 0 - 360.");
            }

            if (0f > saturation || 1f < saturation) {
                throw new ArgumentOutOfRangeException ("saturation", saturation, "Value must be within a range of 0 - 1.");
            }

            if (0f > brightness || 1f < brightness) {
                throw new ArgumentOutOfRangeException ("brightness", brightness, "Value must be within a range of 0 - 1.");
            }

            if (0 == saturation) {
                return System.Drawing.Color.FromArgb (alpha, Convert.ToInt32 (brightness * 255), Convert.ToInt32 (brightness * 255), Convert.ToInt32 (brightness * 255));
            }

            float fMax, fMid, fMin;
            int iSextant, iMax, iMid, iMin;

            if (0.5 < brightness) {
                fMax = brightness - (brightness * saturation) + saturation;
                fMin = brightness + (brightness * saturation) - saturation;
            }
            else {
                fMax = brightness + (brightness * saturation);
                fMin = brightness - (brightness * saturation);
            }

            iSextant = (int)Math.Floor (hue / 60f);
            if (300f <= hue)
                hue -= 360f;

            hue /= 60f;
            hue -= 2f * (float)Math.Floor (((iSextant + 1f) % 6f) / 2f);
            
            if (0 == iSextant % 2)
                fMid = hue * (fMax - fMin) + fMin;
            else
                fMid = fMin - hue * (fMax - fMin);

            iMax = Convert.ToInt32 (fMax * 255);
            iMid = Convert.ToInt32 (fMid * 255);
            iMin = Convert.ToInt32 (fMin * 255);

            switch (iSextant) {
                case 1:
                    return System.Drawing.Color.FromArgb (alpha, iMid, iMax, iMin);
                case 2:
                    return System.Drawing.Color.FromArgb (alpha, iMin, iMax, iMid);
                case 3:
                    return System.Drawing.Color.FromArgb (alpha, iMin, iMid, iMax);
                case 4:
                    return System.Drawing.Color.FromArgb (alpha, iMid, iMin, iMax);
                case 5:
                    return System.Drawing.Color.FromArgb (alpha, iMax, iMin, iMid);
                default:
                    return System.Drawing.Color.FromArgb (alpha, iMax, iMid, iMin);
            }
        }
        */

        public static ImageCodecInfo GetEncoderInfo (String mimeType) {
            ImageCodecInfo[] encoders = ImageCodecInfo.GetImageEncoders ();

            foreach (ImageCodecInfo t in encoders)
                if (t.MimeType == mimeType)
                    return t;

            return null;
        }

        public static byte[] SaveImage_ToBytes (System.Drawing.Image iImage, bool bAndDispose = false)
        {
            try {
                ImageCodecInfo codec = PetesUtils.GetEncoderInfo ("image/png");

                Encoder qualityEncoder = Encoder.Quality;
                EncoderParameter ratio = new EncoderParameter (qualityEncoder, 100L);
                EncoderParameters codecParams = new EncoderParameters (1);
                codecParams.Param [0] = ratio;

                byte[] b = null;

                using (MemoryStream ms = new MemoryStream ()) {
                    iImage.Save (ms, codec, codecParams);

                    b = ms.ToArray ();

                    if (bAndDispose)
                        iImage.Dispose ();
                }

                return b;
            }
            catch { }

            return null;
        }

    }
}
