using AllocsFixes.JSON;
using AllocsFixes.PersistentData;
using System;
using System.Collections.Generic;
using System.Net;

namespace AllocsFixes.NetConnections.Servers.Web.API
{
	public class GetLandClaims : WebAPI
	{
		public override void HandleRequest (HttpListenerRequest req, HttpListenerResponse resp, WebConnection user, int permissionLevel)
		{
			string ViewersSteamID = string.Empty;
            ulong lViewersSteamID = 0L;

			if (req.QueryString ["steamid"] != null) {
				ViewersSteamID = req.QueryString ["steamid"];
                if (ViewersSteamID.Length != 17 || !ulong.TryParse (ViewersSteamID, out lViewersSteamID)) {
					resp.StatusCode = (int)HttpStatusCode.BadRequest;
					Web.SetResponseTextContent (resp, "Invalid SteamID given");
					return;
				}
			}

            // default user, cheap way to avoid 'null reference exception'
            try { user = user ?? new WebConnection ("", "", 0L); } catch { }

            bool bViewAll = false; try { bViewAll = user.CanViewAllClaims (permissionLevel); } catch { }
            
			JSONObject result = new JSONObject ();
			result.Add ("claimsize", new JSONNumber (GamePrefs.GetInt (EnumGamePrefs.LandClaimSize)));

			JSONArray claimOwners = new JSONArray ();
			result.Add ("claimowners", claimOwners);

			Dictionary<Vector3i, PersistentPlayerData> d = GameManager.Instance.GetPersistentPlayerList ().m_lpBlockMap;
			if (d != null) {
				World w = GameManager.Instance.World;
				Dictionary<PersistentPlayerData, List<Vector3i>> owners = new Dictionary<PersistentPlayerData, List<Vector3i>> ();

                // Add all owners to this temporary list regardless of permissions
				foreach (KeyValuePair<Vector3i, PersistentPlayerData> kvp in d) {
					if (kvp.Value.PlayerId.Equals (ViewersSteamID)) {
						if (!owners.ContainsKey (kvp.Value)) {
							owners.Add (kvp.Value, new List<Vector3i> ());
						}
						owners [kvp.Value].Add (kvp.Key);
					}
				}

                // Loop through all claim owners...
				foreach (KeyValuePair<PersistentPlayerData, List<Vector3i>> kvp in owners) {
                    try
                    {
                        // ... but only show us claims that are from the current web user or if the current web user can see all claims regardless of ownership
                        if (kvp.Key.PlayerId.Equals (ViewersSteamID) || bViewAll)
                        {
                            string currentSteamID = kvp.Key.PlayerId;
                            bool isActive = w.IsLandProtectionValidForPlayer (kvp.Key);

                            JSONObject owner = new JSONObject ();
                            claimOwners.Add (owner);

                            owner.Add("steamid", new JSONString (currentSteamID));
                            owner.Add("claimactive", new JSONBoolean (isActive));

                            if (PersistentContainer.Instance.Players [currentSteamID, false] != null) {
                                owner.Add("playername", new JSONString (PersistentContainer.Instance.Players [currentSteamID, false].Name));
                            } else {
                                owner.Add("playername", new JSONNull ());
                            }

                            JSONArray claims = new JSONArray ();
                            owner.Add ("claims", claims);

                            foreach (Vector3i v in kvp.Value) {
                                JSONObject claim = new JSONObject ();
                                claim.Add ("x", new JSONNumber (v.x));
                                claim.Add ("y", new JSONNumber (v.y));
                                claim.Add ("z", new JSONNumber (v.z));

                                claims.Add (claim);
                            }
                        }
                    }
                    catch { }
				}
			}

			WriteJSON (resp, result);
		}
	}
}

