using System;
using System.Collections.Generic;
using AllocsFixes.NetConnections.Servers.Web;
using UnityEngine;

namespace AllocsFixes.NetConnections.Servers.Web
{
	public class WebConnection : ConsoleConnectionAbstract {
		private string sessionId;
		private string endpoint;
		private ulong steamId;
		private DateTime login;
		private DateTime lastAction;
		private List<string> outputLines = new List<string> ();

		public string SessionID {
			get { return sessionId; }
		}

		public string Endpoint {
			get { return endpoint; }
		}

		public ulong SteamID {
			get { return steamId; }
		}

		public TimeSpan Age {
			get { return DateTime.Now - lastAction; }
		}

        public bool CanViewAllPlayers (int _permissionLevel) {
            bool val = false;

            try {
                const int defaultPermissionLevel = 0;

                val = _permissionLevel <= defaultPermissionLevel;

                foreach (WebPermissions.WebModulePermission wap in WebPermissions.Instance.GetModules ())
                    if (wap.module.Trim ().ToLower () == "webapi.viewallplayers")
                        val = _permissionLevel <= wap.permissionLevel;
            }
            catch { }

            return val;
        }

        public bool CanViewAllClaims (int _permissionLevel) {
            bool val = false;

            try {
                const int defaultPermissionLevel = 0;

                val = _permissionLevel <= defaultPermissionLevel;

                foreach (WebPermissions.WebModulePermission wap in WebPermissions.Instance.GetModules ())
                    if (wap.module.Trim ().ToLower () == "webapi.viewallclaims")
                        val = _permissionLevel <= wap.permissionLevel;
            }
            catch { }

            return val;
        }

		public WebConnection (string _sessionId, string _endpoint, ulong _steamId) {
			this.sessionId = _sessionId;
			this.endpoint = _endpoint;
			this.steamId = _steamId;
			this.login = DateTime.Now;
			this.lastAction = this.login;
		}

		public void UpdateUsage () {
			this.lastAction = DateTime.Now;
		}

		public override string GetDescription () {
			return "WebPanel from " + endpoint;
		}

		public override void SendLine (string _text) {
			outputLines.Add (_text);
		}

		public override void SendLines (List<string> _output) {
			outputLines.AddRange (_output);
		}

		public override void SendLog (string _msg, string _trace, LogType _type) {
			// Do nothing, handled by LogBuffer
		}

	}
}

