using System;
using System.Collections.Generic;

namespace AllocsFixes.CustomCommands
{
	public class BuffPlayer : ConsoleCmdAbstract
	{
		public override string GetDescription ()
		{
			return "Apply a buff to a player";
		}

		public override string GetHelp () {
			return "Usage:\n" +
				   "   buffplayer <player name / steam id / entity id> <buff name>\n" +
				   "Apply the given buff to the player given by the player name or entity id (as given by e.g. \"lpi\").";
		}

		public override string[] GetCommands ()
		{
			return new string[] { "buffplayer" };
		}

		public override void Execute (List<string> _params, CommandSenderInfo _senderInfo)
		{
			try {
				if (_params.Count != 2) {
					SdtdConsole.Instance.Output ("Invalid arguments");
					return;
				}

				string buff = _params [1];

				ClientInfo receiver = ConsoleHelper.ParseParamIdOrName (_params [0]);
				if (receiver != null) {
					receiver.SendPackage (new NetPackageConsoleCmdClient ("buff " + buff, true));
				} else {
					SdtdConsole.Instance.Output ("Playername or entity ID not found.");
				}
			} catch (Exception e) {
				Log.Out ("Error in BuffPlayer.Run: " + e);
			}
		}
	}
}
