using System;
using System.Collections.Generic;

namespace AllocsFixes.CustomCommands
{
	public class DebuffPlayer : ConsoleCmdAbstract
	{
		public override string GetDescription ()
		{
			return "Remove a buff from a player";
		}

		public override string GetHelp () {
			return "Usage:\n" +
				   "   debuffplayer <player name / steam id / entity id> <buff name>\n" +
				   "Remove the given buff from the player given by the player name or entity id (as given by e.g. \"lpi\").";
		}

		public override string[] GetCommands ()
		{
			return new string[] { "debuffplayer" };
		}

		public override void Execute (List<string> _params, CommandSenderInfo _senderInfo)
		{
			try {
				if (_params.Count != 2) {
					SdtdConsole.Instance.Output ("Invalid arguments");
					return;
				}

				string buff = _params [1];

				ClientInfo receiver = ConsoleHelper.ParseParamIdOrName (_params [0]);
				if (receiver != null) {
					receiver.SendPackage (new NetPackageConsoleCmdClient ("debuff " + buff, true));
				} else {
					SdtdConsole.Instance.Output ("Playername or entity ID not found.");
				}
			} catch (Exception e) {
				Log.Out ("Error in DebuffPlayer.Run: " + e);
			}
		}
	}
}
