using AllocsFixes.JSON;
using AllocsFixes.PersistentData;
using System;
using System.Collections.Generic;
using System.Net;

namespace AllocsFixes.NetConnections.Servers.Web.API
{
	public class GetPlayersLocation : WebAPI
	{
		public override void HandleRequest (HttpListenerRequest req, HttpListenerResponse resp, WebConnection user, int permissionLevel)
		{
            AdminTools admTools = GameManager.Instance.adminTools;
            user = user ?? new WebConnection ("", "", 0L);

            bool bViewAll = WebConnection.CanViewAllPlayers (permissionLevel);

            JSONArray playersJsResult = new JSONArray ();

			Players playersList = PersistentContainer.Instance.Players;

			foreach (string sid in playersList.SteamIDs) {
                if (admTools != null)
                    if (admTools.IsBanned (sid))
                        continue;

                Player p = playersList [sid, false];

                ulong player_steam_ID = 0L;
                if (!ulong.TryParse (sid, out player_steam_ID))
                    player_steam_ID = 0L;

                if ((player_steam_ID == user.SteamID) || bViewAll) {
                    JSONObject pos = new JSONObject ();
                    pos.Add("x", new JSONNumber (p.LastPosition.x));
                    pos.Add("y", new JSONNumber (p.LastPosition.y));
                    pos.Add("z", new JSONNumber (p.LastPosition.z));

                    JSONObject pJson = new JSONObject ();
                    pJson.Add("steamid", new JSONString (sid));
                    pJson.Add("ip", new JSONString (p.IP));
                    pJson.Add("name", new JSONString (p.Name));
                    pJson.Add("online", new JSONBoolean (p.IsOnline));
                    pJson.Add("position", pos);

                    playersJsResult.Add (pJson);
                }
            }

			WriteJSON (resp, playersJsResult);
		}
	}
}

