using AllocsFixes.JSON;
using AllocsFixes.PersistentData;
using System;
using System.Collections.Generic;
using System.Net;

namespace AllocsFixes.NetConnections.Servers.Web.API
{
	public class GetLandClaims : WebAPI {
		public override void HandleRequest (HttpListenerRequest req, HttpListenerResponse resp, WebConnection user, int permissionLevel) {
			string requestedSteamID = string.Empty;

			if (req.QueryString ["steamid"] != null) {
				ulong lViewersSteamID;
				requestedSteamID = req.QueryString ["steamid"];
				if (requestedSteamID.Length != 17 || !ulong.TryParse (requestedSteamID, out lViewersSteamID)) {
					resp.StatusCode = (int)HttpStatusCode.BadRequest;
					Web.SetResponseTextContent (resp, "Invalid SteamID given");
					return;
				}
			}

			// default user, cheap way to avoid 'null reference exception'
			user = user ?? new WebConnection ("", "", 0L);

			bool bViewAll = WebConnection.CanViewAllClaims (permissionLevel);
            
			JSONObject result = new JSONObject ();
			result.Add ("claimsize", new JSONNumber (GamePrefs.GetInt (EnumGamePrefs.LandClaimSize)));

			JSONArray claimOwners = new JSONArray ();
			result.Add ("claimowners", claimOwners);

			LandClaimList.OwnerFilter[] ownerFilters = null;
			if (!string.IsNullOrEmpty (requestedSteamID) || !bViewAll) {
				if (!string.IsNullOrEmpty (requestedSteamID) && !bViewAll) {
					ownerFilters = new LandClaimList.OwnerFilter[] {
						LandClaimList.SteamIdFilter (user.SteamID.ToString ()),
						LandClaimList.SteamIdFilter (requestedSteamID)
					};
				} else if (!bViewAll) {
					ownerFilters = new LandClaimList.OwnerFilter[] { LandClaimList.SteamIdFilter (user.SteamID.ToString ()) };
				} else {
					ownerFilters = new LandClaimList.OwnerFilter[] { LandClaimList.SteamIdFilter (requestedSteamID) };
				}
			}
			LandClaimList.PositionFilter[] posFilters = null;

			Dictionary<PersistentData.Player, List<Vector3i>> claims = LandClaimList.GetLandClaims (ownerFilters, posFilters);

			foreach (KeyValuePair<PersistentData.Player, List<Vector3i>> kvp in claims) {

				try {
					JSONObject owner = new JSONObject ();
					claimOwners.Add (owner);

					owner.Add ("steamid", new JSONString (kvp.Key.SteamID));
					owner.Add ("claimactive", new JSONBoolean (kvp.Key.LandProtectionActive));

					if (kvp.Key.Name.Length > 0) {
						owner.Add ("playername", new JSONString (kvp.Key.Name));
					} else {
						owner.Add ("playername", new JSONNull ());
					}

					JSONArray claimsJson = new JSONArray ();
					owner.Add ("claims", claimsJson);

					foreach (Vector3i v in kvp.Value) {
						JSONObject claim = new JSONObject ();
						claim.Add ("x", new JSONNumber (v.x));
						claim.Add ("y", new JSONNumber (v.y));
						claim.Add ("z", new JSONNumber (v.z));

						claimsJson.Add (claim);
					}
				} catch {
				}
			}

			WriteJSON (resp, result);
		}
	}
}

