#!/bin/bash

#   Copyright 2016 Christian 'Alloc' Illy
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.


# Downloads SteamCMD, downloads/updates the 7dtd engine

sdtdCommandUpdateengine() {
#	local FORCED=no
#	if [ "$1" = "--force" ]; then
#		FORCED=yes
#	fi

	local EXPERIMENTAL=no
	if [ "$1" = "--experimental" ]; then
		EXPERIMENTAL=yes
	fi

	if [ ! -e $SDTD_BASE/steamcmd ]; then
		mkdir $SDTD_BASE/steamcmd
		cd /tmp
		wget http://media.steampowered.com/installer/steamcmd_linux.tar.gz
		tar -xvzf steamcmd_linux.tar.gz -C $SDTD_BASE/steamcmd
		cd $SDTD_BASE/steamcmd
		./steamcmd.sh +quit
	fi

#	if [ "$1" = "--check" -o "$2" = "--check" ]; then
#		local LOCAL=$(getLocalEngineVersion)
#		local REMOTE=$(getRemoteEngineVersion)
#		if [ $REMOTE -gt $LOCAL ]; then
#			echo "Newer engine version available."
#		else
#			echo "Engine up to date."
#		fi
#		echo "Local buildid:     $LOCAL"
#		echo "Available buildid: $REMOTE"
#		return
#	fi

	for I in $(getInstanceList); do
		if [ $(isRunning $I) -eq 1 ]; then
			echo "At least one instance is still running (\"$I\")."
			echo "Before updating the engine please stop all instances!"
			return
		fi
	done

	local LOCAL=$(getLocalEngineVersion)
	#local REMOTE=$(getRemoteEngineVersion)
	#local LOCAL_SUPPORTED_BUILD=$(cat /usr/local/lib/7dtd/VERSION | grep "DediBuild" | cut -d\  -f2)

#	if [ "$FORCED" = "yes" -o $REMOTE -gt $LOCAL ]; then
#		echo "A newer version of the engine is available."
		echo "Local buildid:     $LOCAL"
		#echo "Available buildid: $REMOTE"
		echo

#		if [ "$LOCAL_SUPPORTED_BUILD" != "$REMOTE" ]; then
#			echo "WARNING!!! The currently installed version of the scripts might not support the newer dedicated server build!"
#			echo "If you continue you might not be able to start the server."
#			echo "Please wait for an updated release of the scripts or continue at your own risk."
#			echo
#		fi
	
		while : ; do
			local CONTINUE
			read -p "Continue? (yn) " CONTINUE
			case $CONTINUE in
				y)
					echo "Updating..."
					break
					;;
				n)
					echo "Canceled"
					return
					;;
				*)
					echo "Wrong input"
			esac
		done
		
		local BRANCH_PARAM=
		if [ "$EXPERIMENTAL" = "yes" ]; then
			BRANCH_PARAM="-beta latest_experimental"
		fi
		
		cd $SDTD_BASE/steamcmd
		./steamcmd.sh +login anonymous +force_install_dir $SDTD_BASE/engine +app_update 294420 -validate $BRANCH_PARAM +quit

		if [ -d /usr/local/lib/7dtd/server-fixes ]; then
			cp /usr/local/lib/7dtd/server-fixes/* $SDTD_BASE/engine/ -R
		fi

		chown $SDTD_USER.$SDTD_GROUP -R $SDTD_BASE/engine

#		if [ "$LOCAL_SUPPORTED_BUILD" != "$REMOTE" ]; then
#			echo
#			echo "Also update the scripts as soon as there is a new release for this dedicated server build."
#			echo
#		fi
#	else
#		echo "Engine is already at the newest build (local: $LOCAL, remote: $REMOTE)."
#	fi
}

sdtdCommandUpdateengineHelp() {
	echo "Usage: $(basename $0) updateengine [--experimental]" # [--force | --check]"
	echo
	echo "Check for a newer version of engine (aka game) files of 7dtd. If there is a newer"
	echo "version they will be updated by this command."
	echo
	echo "If --experimental is specified the server will be updated to the"
	echo "latest_experimental Steam branch of the game."
#	echo
#	echo "If --force is specified you are asked if you want to redownload the engine"
#	echo "even if there is no new version available."
#	echo
#	echo "If --check is specified it will only output the current local and remote build ids"
#	echo "and if an update is available."
}

sdtdCommandUpdateengineDescription() {
	echo "Update the 7dtd engine files"
}

sdtdCommandUpdateengineExpects() {
	case $1 in
		2)
			echo "--experimental"
			;;
	esac
#	case $1 in
#		2)
#			echo "--force --check"
#			;;
#	esac
	echo
}

