using System;
using System.Collections.Generic;
using System.Reflection;

namespace AllocsFixes.CustomCommands
{
	public class RepairChunkDensity : ConsoleCmdAbstract {
		public override string GetDescription () {
			return "check and optionally fix densities of a chunk";
		}

		public override string GetHelp () {
			return "Usage:\n" +
				"  1. repairchunkdensity <x> <z>\n" +
				"  2. repairchunkdensity <x> <z> fix\n" +
				"1. Teleports the player given by his SteamID, player name or entity id (as given by e.g. \"lpi\")\n" +
				"   to the specified location. Use y = -1 to spawn on ground.\n" +
				"2. As 1, but destination given by another player which has to be online\n" +
				"3. Teleport the local player to the position calculated by his current position and the given offsets";
		}

		public override string[] GetCommands () {
			return new string[] { "repairchunkdensity", "rcd" };
		}

		public override void Execute (List<string> _params, CommandSenderInfo _senderInfo) {
			try {
				if (_params.Count < 2 || _params.Count > 3) {
					SdtdConsole.Instance.Output ("Wrong number of arguments, expected 2 or 3, found " + _params.Count + ".");
					return;
				} else {
					int x = int.MinValue;
					int z = int.MinValue;

					int.TryParse (_params [0], out x);
					int.TryParse (_params [1], out z);

					if (x == int.MinValue || z == int.MinValue) {
						SdtdConsole.Instance.Output ("At least one of the given coordinates is not a valid integer");
						return;
					}

					Chunk c = GameManager.Instance.World.GetChunkFromWorldPos (x, 0, z) as Chunk;
					if (c == null) {
						SdtdConsole.Instance.Output ("No chunk could be loaded from the given coordinates");
						return;
					}

					if (_params.Count == 3) {
						if (_params [2].ToLower () != "fix") {
							SdtdConsole.Instance.Output ("Three parameters given but third parameter is not \"fix\"");
							return;
						}
						c.RepairDensities ();
						c.isModified = true;
						SdtdConsole.Instance.Output ("Chunk repaired");
					} else {
						c.CheckDensities (true);
					}
				}
			} catch (Exception e) {
				Log.Out ("Error in RepairChunkDensity.Execute: " + e);
			}
		}

	}
}
