using System;
using System.Collections.Generic;
using System.Reflection;

namespace CoppisAdditions.CustomCommands
{
	public class ListPlayersBed : ConsoleCmdAbstract
	{
		public override string GetDescription ()
		{
			return "list bed locations of all players or a specific player";
		}

		public override string GetHelp ()
		{
			return "Usage:\n" +
			"  1. lpb <steam id / player name / entity id>" +
			"or " +
			"  2. lpb  *this will list all players online and their bed";
		}

		public override string[] GetCommands ()
		{
			return new string[] { "listplayerbed", "lpb" };
		}

		public override void Execute (List<string> _params, CommandSenderInfo _senderInfo)
		{
			try {
				if (_params.Count > 1) {
					SdtdConsole.Instance.Output ("Usage: listplayerbed <entityid|playername|steamid> or listplayerbed (without params)");
				} else {
					if (_params.Count == 1) {
						ClientInfo ci1 = ConsoleHelper.ParseParamIdOrName (_params [0]);
						if (ci1 == null) {
							SdtdConsole.Instance.Output ("Playername or entity/steamid id not found.");
							return;
						}
						EntityPlayer ep1 = GameManager.Instance.World.Players.dict [ci1.entityId];
						EntityBedrollPositionList bed = ep1.SpawnPoints;

						if (bed.Count == 0) {
							SdtdConsole.Instance.Output ("The player does not have a bed");
							return;
						}
						for (int x = 0; x < bed.Count; x++) {
							Vector3i pos = bed [x];
							SdtdConsole.Instance.Output ("PlayerBed: " + ep1.EntityName + " at " + pos.x + ", " + pos.y + ", " + pos.z);
						}
					} else if (_params.Count == 0) {
						Dictionary<int, EntityPlayer>.Enumerator enumerator = GameManager.Instance.World.Players.dict.GetEnumerator ();
						while (enumerator.MoveNext ()) {
							KeyValuePair<int, EntityPlayer> pair = enumerator.Current;
							EntityPlayer ep1 = pair.Value;
							EntityBedrollPositionList bed = ep1.SpawnPoints;
							if (bed.Count == 0) {
								SdtdConsole.Instance.Output ("The player " + ep1.EntityName + " does not have any bed");
								return;
							} else {
								for (int x = 0; x < bed.Count; x++) {
									Vector3i pos = bed [x];
									SdtdConsole.Instance.Output (ep1.EntityName + ": " + pos.x + ", " + pos.y + ", " + pos.z);
								}
							}
						}
					}
				}
			} catch (Exception e) {
				Log.Out ("Error in ListPlayersBed.Run: " + e);
			}
		}
	}
}
