using System;
using System.Collections.Generic;
using System.Reflection;

namespace CoppisAdditions.CustomCommands
{
	public class ListPlayersFriends : ConsoleCmdAbstract
	{
		public override string GetDescription ()
		{
			return "list friends of a single player or all players";
		}

		public override string GetHelp ()
		{
			return "Usage:\n" +
			"  1. lpf <steam id / player name / entity id>" +
			"  2. lpf (to list all players friends)";
		}

		public override string[] GetCommands ()
		{
			return new string[] { "listplayerfriends", "lpf" };
		}

		public override void Execute (List<string> _params, CommandSenderInfo _senderInfo)
		{
			try {
				if (_params.Count > 1) {
					SdtdConsole.Instance.Output ("Usage: listplayerfriends <entityid|playername|steamid> or listplayerfriends");
				} else {
					if (_params.Count == 0) {
						Dictionary<int, EntityPlayer>.Enumerator playerEnum = GameManager.Instance.World.Players.dict.GetEnumerator ();
						while (playerEnum.MoveNext ()) {
							try {
								KeyValuePair<int, EntityPlayer> pair = playerEnum.Current;
								ClientInfo ci1 = ConsoleHelper.ParseParamIdOrName (pair.Value.entityId.ToString ());
								PersistentPlayerData data = GameManager.Instance.persistentPlayers.GetPlayerData (ci1.playerId);
								HashSet<string>.Enumerator enumeratorFriends = data.ACL.GetEnumerator ();
								String friends = "";
								while (enumeratorFriends.MoveNext ()) {
									string str = enumeratorFriends.Current;
									if (str != null) {
										if (!friends.Equals ("")) {
											friends += ",";
										}
										friends += str;
									}
								}
								SdtdConsole.Instance.Output ("FriendsOf id=" + pair.Value.entityId + ", friends=" + friends);
							} catch (Exception e) {
                                
							}
						}
					} else { 
						ClientInfo ci = ConsoleHelper.ParseParamIdOrName (_params [0]);
						if (ci == null) {
							SdtdConsole.Instance.Output ("Playername or entity/steamid id not found.");
							return;
						}
						EntityPlayer ep = GameManager.Instance.World.Players.dict [ci.entityId];
						PersistentPlayerData data = GameManager.Instance.persistentPlayers.GetPlayerDataFromEntityID (ci.entityId);

						HashSet<string>.Enumerator enumerator = data.ACL.GetEnumerator ();
						//int count = 0;
						String friends = "";
						while (enumerator.MoveNext ()) {
							string str = enumerator.Current;
							if (!friends.Equals ("")) {
								friends += ",";
							}
							friends += str;
                           
							//Player p = PersistentContainer.Instance.Players[str, false];
							//if (p == null)
							//{
							//  continue;
							//}
							//count++;
							//SdtdConsole.Instance.Output(count + ": " + p.EntityID + " - " + p.Name);
						}
						SdtdConsole.Instance.Output ("FriendsOf id=" + ci.entityId + ", friends=" + friends);
					}
				}
			} catch (Exception e) {
				Log.Out ("Error in ListPlayersFriends.Run: " + e);
			}
		}
	}
}
