using System;
using System.Collections.Generic;
using AllocsFixes.PersistentData;
using System.Threading;
using UnityEngine;

namespace CoppisAdditions.CustomCommands
{
	public class PlayerChatMaxLength : ConsoleCmdAbstract
	{
		public override string GetDescription ()
		{
			return "set the maximum number of characters a player can write in a single message";
		}

		public override string GetHelp ()
		{
			return "Set the maximum number of characters a player can write in a single message." +
			"Usage:\n" +
			"   pcml <steam id/player name/entity id> <chat length>\n";
		}

		public override string[] GetCommands ()
		{
			return new string[] { "playerchatmaxlength", "pcml" };
		}

		public override void Execute (List<string> _params, CommandSenderInfo _senderInfo)
		{
			try {
				if (_params.Count != 2) {
					SdtdConsole.Instance.Output ("Wrong number of arguments, expected 2, found " + _params.Count + ".");
					SdtdConsole.Instance.Output (" ");
					SdtdConsole.Instance.Output (GetHelp ());
					return;
				}

				string steamid = PersistentContainer.Instance.Players.GetSteamID (_params [0], true);
				if (steamid == null) {
					SdtdConsole.Instance.Output ("Playername or entity/steamid id not found.");
					return;
				}

				int maxLen = int.MinValue;
				int.TryParse (_params [1], out maxLen);

				if (maxLen == int.MinValue || maxLen < 1) {
					SdtdConsole.Instance.Output ("the parameter \"chat length\" must be an integer equal or greater than 1");
					return;
				}


				Player p = PersistentContainer.Instance.Players [steamid, false];
				if (p != null) {
					p.MaxChatLength  = maxLen;
					SdtdConsole.Instance.Output (p.Name + ": max chat length changed to " + maxLen);
				}

			} catch (Exception e) {
				Log.Out ("Error in PlayerChatMaxLength: " + e);
			}
		}
	}
}
