using System;
using System.Collections.Generic;
using AllocsFixes.PersistentData;
using System.Threading;
using UnityEngine;

namespace CoppisAdditions.CustomCommands
{
	public class ToogleChatCommandHide : ConsoleCmdAbstract
	{
		public override string GetDescription ()
		{
			return "specify a chat message prefix that defines chat commands that are hidden from chat";
		}

		public override string GetHelp ()
		{
			return "If used chat messages starting with the defined prefix (e.g. \"/\") will not be shown to other players." +
			"Usage:\n" +
			"   tcch \n" +
			"    - If used without any parameter this functionality is disabled" +
			"   tcch <string pattern> \n" +
			"    * do not use string pattern with spaces.\n" +
			"    - define the prefix for chat commands\n" +
			"   Example: tcch / \n" +
			"    - Chat messages like \"/help\" will be hidden\n";
		}

		public override string[] GetCommands ()
		{
			return new string[] { "tooglechatcommandhide", "tcch" };
		}

		public override void Execute (List<string> _params, CommandSenderInfo _senderInfo)
		{
			try {
				if (_params.Count > 1) {
					SdtdConsole.Instance.Output ("Wrong number of arguments, expected 1, found " + _params.Count + ".");
					SdtdConsole.Instance.Output (" * Do not use string pattern with spaces.");
					SdtdConsole.Instance.Output (GetHelp ());
					return;
				}

				if (_params.Count == 0) {
					PersistentContainer.Instance.Attributes.HideChatCommandPrefix = "";
					PersistentContainer.Instance.Attributes.HideChatCommands = false;
					SdtdConsole.Instance.Output ("Chat command hiding disabled");
				} else {
					PersistentContainer.Instance.Attributes.HideChatCommandPrefix = _params [0];
					PersistentContainer.Instance.Attributes.HideChatCommands = true;
					SdtdConsole.Instance.Output ("Prefix \"" + _params [0] + "\" defined for chat commands");
				}
			} catch (Exception e) {
				Log.Out ("Error in ToogleChatCommandHide: " + e);
			}
		}
	}
}
