using System;
using System.Collections.Generic;
using AllocsFixes.PersistentData;
using System.Threading;
using UnityEngine;

namespace CoppisAdditions.CustomCommands
{
	public class MutePlayerChat : ConsoleCmdAbstract
	{
		public override string GetDescription ()
		{
			return "mute a player on public chat";
		}

		public override string GetHelp ()
		{
			return "Mute a player on public chat." +
			"Usage:\n" +
			"   mpc <steam id/player name/entity id> [true/false]\n" +
			"If the optional parameter is not given the command will show the current status.";
		}

		public override string[] GetCommands ()
		{
			return new string[] { "muteplayerchat", "mpc" };
		}

		public override void Execute (List<string> _params, CommandSenderInfo _senderInfo)
		{
			try {
				if (_params.Count < 1 || _params.Count > 2) {
					SdtdConsole.Instance.Output ("Wrong number of arguments, expected 1 or 2, found " + _params.Count + ".");
					SdtdConsole.Instance.Output (" ");
					SdtdConsole.Instance.Output (GetHelp ());
					return;
				}

				string steamid = PersistentContainer.Instance.Players.GetSteamID (_params [0], true);
				if (steamid == null) {
					SdtdConsole.Instance.Output ("Playername or entity/steamid id not found.");
					return;
				}

				Player p = PersistentContainer.Instance.Players [steamid, false];
				if (p == null) {
					SdtdConsole.Instance.Output ("Player not found.");
					return;
				}

				if (_params.Count > 1) {
					bool mute = false;
					if (_params [1].ToLower () == "true") {
						mute = true;
					} else if (_params [1].ToLower () == "false") {
						mute = false;
					} else {
						SdtdConsole.Instance.Output ("Wrong param 2. It must be \"true\" or \"false\"");
						return;
					}
					p.IsChatMuted = mute;
				}
				SdtdConsole.Instance.Output (p.Name + " " + (p.IsChatMuted ? "muted" : "unmuted"));

			} catch (Exception e) {
				Log.Out ("Error in MutePlayerChat: " + e);
			}
		}
	}
}
