using System;
using System.Collections.Generic;
using System.IO;

using UnityEngine;

namespace CoppisAdditions.CustomCommands
{
	public class Physics : ConsoleCmdAbstract
	{
		public override string GetDescription ()
		{
			return "Enable / Disable Physics on blocks that you are placing/removing";
		}

		public override string GetHelp ()
		{
			return "Enable / Disable Physics on blocks that you are placing/removing";
		}

		public override string[] GetCommands ()
		{
			return new string[] { "physics", "py" };
		}

		public override void Execute (List<string> _params, CommandSenderInfo _senderInfo)
		{
			try {
				GameManager.bPhysicsActive = !GameManager.bPhysicsActive;
				SdtdConsole.Instance.Output ("Physics enabled: " + GameManager.bPhysicsActive);
			} catch (Exception e) {
				Log.Out ("Error in Physics.Run: " + e);
			}
		}
	}
}
