using System;
using System.Collections.Generic;
using System.IO;
using UnityEngine;

namespace CoppisAdditions.CustomCommands
{
	public class UnlockAll : ConsoleCmdAbstract
	{
		public override string GetDescription ()
		{
			return "unlock all secure loots, chests and doors for the current player.";
		}

		public override string GetHelp ()
		{
			return "Unlock all secure loots, chests and doors for the current player. After using this command you need to leave and reenter the game to take effect.";
		}

		public override string[] GetCommands ()
		{
			return new string[] { "unlockall" };
		}

		public override void Execute (List<string> _params, CommandSenderInfo _senderInfo)
		{
			try { 
				if (_senderInfo.RemoteClientInfo == null || _senderInfo.RemoteClientInfo.playerId == null || _senderInfo.RemoteClientInfo.playerId.Equals ("")) {
					SdtdConsole.Instance.Output ("Unable to apply this command. You need be a player to execute it.");
					return;
				}
				ClientInfo ci = ConsoleHelper.ParseParamIdOrName (_senderInfo.RemoteClientInfo.playerName);
				ChunkClusterList chunklist = GameManager.Instance.World.ChunkClusters;
				string SteamID = _senderInfo.RemoteClientInfo.playerId;
				int lootsUnlocked = 0;
				int doorsUnlocked = 0;
				for (int i = 0; i < chunklist.Count; i++) {
					ChunkCluster chunk = chunklist [i];
					List<Chunk> clist = chunk.GetChunkArray ();
					foreach (Chunk c in clist) {
						DictionarySave<Vector3i, TileEntity> tiles = c.GetTileEntities ();
						foreach (TileEntity tile in tiles.Values) {
							TileEntityType type = tile.GetTileEntityType ();
							try {
								if (type.ToString ().Equals ("Campfile")) {
									//TileEntityCampfire campfire = (TileEntityCampfire)tile;
									//SdtdConsole.Instance.Output("campfire: " + );
								} else if (type.ToString ().Equals ("Loot")) {
									//TileEntityLootContainer loot = (TileEntityLootContainer) tile;

								} else if (type.ToString ().Equals ("Forge")) {
									//TileEntityForge forge = (TileEntityForge) tile;
								} else if (type.ToString ().Equals ("SecureLoot")) {
									TileEntitySecureLootContainer secureLoot = (TileEntitySecureLootContainer)tile;
									//SdtdConsole.Instance.Output("secure loot ower: " + secureLoot.GetOwner());
									List<string> users = secureLoot.GetUsers ();
									if (!users.Contains (SteamID)) {
										users.Add (SteamID);
										lootsUnlocked = lootsUnlocked + 1;
									}
								} else if (type.ToString ().Equals ("SecureDoor")) {
									TileEntitySecureDoor secureDoor = (TileEntitySecureDoor)tile;
									List<string> users = secureDoor.GetUsers ();
									if (!users.Contains (SteamID)) {
										users.Add (SteamID);
										doorsUnlocked = doorsUnlocked + 1;
									}
								}
							} catch (Exception) {

							}
						}
					}

                    
					if (ci != null) {
						ci.SendPackage (new NetPackageChunkClusterInfo (chunk));
					}
				}
				SdtdConsole.Instance.Output ("Secure Loots/Chest unlocked: " + lootsUnlocked);
				SdtdConsole.Instance.Output ("Secure Doors unlocked: " + doorsUnlocked);
				SdtdConsole.Instance.Output ("*Remember: you need to leave and enter again to apply this command on server`s map");
			} catch (Exception e) {
				Log.Out ("Error in UnlockAll.Run: " + e);
			}

		}
	}
}
