using System;
using System.Collections.Generic;
using System.Reflection;

namespace CoppisAdditions.CustomCommands
{
	public class TeleportPlayerHome : ConsoleCmdAbstract
	{
		public override string GetDescription ()
		{
			return "teleport a player to his home (on bedroll)";
		}

		public override string GetHelp ()
		{
			return "Usage:\n" +
			"  teleportplayerhome <steam id / player name / entity id>";
		}

		public override string[] GetCommands ()
		{
			return new string[] { "teleportplayerhome", "teleh" };
		}

		public override void Execute (List<string> _params, CommandSenderInfo _senderInfo)
		{
			try {
				if (_params.Count != 1) {
					SdtdConsole.Instance.Output ("Usage: teleportplayerhome <entityid|playername|steamid>");
				} else {
					ClientInfo ci1 = ConsoleHelper.ParseParamIdOrName (_params [0]);
					if (ci1 == null) {
						SdtdConsole.Instance.Output ("Playername or entity/steamid id not found.");
						return;
					}
					EntityPlayer ep1 = GameManager.Instance.World.Players.dict [ci1.entityId];
					EntityBedrollPositionList bed = ep1.SpawnPoints;
					if (bed.Count != 0) {
						Vector3i pos = bed [0];
						ep1.position.x = pos.x;
						ep1.position.y = pos.y + 1;
						ep1.position.z = pos.z;

						NetPackageEntityTeleport pkg = new NetPackageEntityTeleport (ep1);
						ci1.SendPackage (pkg);
						SdtdConsole.Instance.Output ("Player teleported to his home at " + ep1.position.x + " " + ep1.position.y + " " + ep1.position.z);
					} else {
						SdtdConsole.Instance.Output ("The player does not have a defined HOME bed!");
					}
				}
			} catch (Exception e) {
				Log.Out ("Error in TeleportPlayerHome.Run: " + e);
			}
		}
	}
}
