using System;
using System.Collections.Generic;
using UnityEngine;

namespace CoppisAdditions.CustomCommands
{
	public class GiveXP : ConsoleCmdAbstract
	{
		public override string GetDescription ()
		{
			return "give an amount XP to a player (entity id or name)";
		}

		public override string GetHelp ()
		{
			return "Give XP to a player\n" +
			"Usage:\n" +
			"   givexp <name / entity id> <amount xp> <skill name>\n" +
			"Skills names are: Athletics, Scavenging, Clothing, Light_Armor, Heavy_Armor, Blunt_Weapons, Blade_Weapons, Mining_Tools, Construction_Tools, Pistols, Shotguns, Rifles, Archery, Medicine, Weapon_Smithing, Tool_Smithing, Gun_Smithing, Science, Tailoring, Leatherworking, Armor_Smithing, Miscellaneous_Crafting, Quality_Joe";
		}

		public override string[] GetCommands ()
		{
			return new string[] { "givexp" };
		}

		public override void Execute (List<string> _params, CommandSenderInfo _senderInfo)
		{
			try {
				if (_params.Count != 3) {
					SdtdConsole.Instance.Output ("Wrong number of arguments, expected 3, found " + _params.Count + ".");
					return;
				}

				ClientInfo ci = ConsoleHelper.ParseParamIdOrName (_params [0]);
				if (ci == null) {
					SdtdConsole.Instance.Output ("Playername or entity id not found.");
					return;
				}

				int xp = int.MinValue;
				int.TryParse (_params [1], out xp);

				if (xp <= 0) {
					SdtdConsole.Instance.Output ("The amount of XP is not a valid positive integer.");
					return;
				}

				String skillName = _params [2].Replace ('_', ' ');

				Skill skill = new Skills ().GetSkillByName (skillName);
				if (skill == null) {
					SdtdConsole.Instance.Output ("Invalid skill name: \"" + skillName + "\"");
					return;
				}
				EntityPlayer ep = GameManager.Instance.World.Players.dict [ci.entityId];
				GameManager.Instance.AddExpServer (ci.entityId, skill.Id, xp);
				SdtdConsole.Instance.Output (xp + " xp was given on skill " + skillName + " to player " + ci.playerName);
			} catch (Exception e) {
				Log.Out ("Error in GiveXP.Execute: " + e);
			}
		}
	}
}
