using System;
using System.Collections.Generic;

namespace CoppisAdditions.CustomCommands
{
	public class SayToPlayer2 : ConsoleCmdAbstract
	{
		public override string GetDescription ()
		{
			return "send a message to a single player with a specific sender name";
		}

		public override string GetHelp ()
		{
			return "Usage:\n" +
			"   pm2 <sender player name / steam id / entity id> <receiver player name / steam id / entity id> <message>\n" +
			"Send a PM from a player to another player, both given by the player name or steam / entity id (as given by e.g. \"lpi\").";
		}

		public override string[] GetCommands ()
		{
			return new string[] { "sayplayer2", "pm2" };
		}

		private void RunInternal (ClientInfo _sender, List<string> _params)
		{
			if (_params.Count < 3) {
				SdtdConsole.Instance.Output ("Usage: sayplayer2 <playername|entityid> <playername|entityid> <message>");
				return;
			}

			string message = _params [2];
			ClientInfo sender = ConsoleHelper.ParseParamIdOrName (_params [0]);
			ClientInfo receiver = ConsoleHelper.ParseParamIdOrName (_params [1]);

			if (sender != null && receiver != null) {
				AllocsFixes.CustomCommands.Chat.SendMessage (receiver, sender, message);
			} else {
				SdtdConsole.Instance.Output ("Playername / SteamID / entity id of either sender or receiver not found.");
			}
		}

		public override void Execute (List<string> _params, CommandSenderInfo _senderInfo)
		{
			try {
				if (_senderInfo.RemoteClientInfo != null) {
					RunInternal (_senderInfo.RemoteClientInfo, _params);
				} else {
					RunInternal (null, _params);
				}
			} catch (Exception e) {
				Log.Out ("Error in SayToPlayer2.Run: " + e);
			}
		}
	}
}
