using System;
using System.Collections.Generic;
using System.Threading;
using UnityEngine;

namespace CoppisAdditions.CustomCommands
{
	public class SpawnHorde : ConsoleCmdAbstract
	{
		public override string GetDescription ()
		{
			return "spawn horde near a player or coordinate";
		}

		public override string GetHelp ()
		{
			return "Spawn horde near a player." +
			"Usage:\n" +
			"   sh <steam id/player name/entity id>\n" +
			"or" +
			"   sh <x> <y> <z>\n";
		}

		public override string[] GetCommands ()
		{
			return new string[] { "spawnhorde", "sh" };
		}

		public override void Execute (List<string> _params, CommandSenderInfo _senderInfo)
		{
			try {
				if (_params.Count != 1 && _params.Count != 3) {
					SdtdConsole.Instance.Output ("Wrong number of arguments, expected 1 or 3, found " + _params.Count + ".");
					SdtdConsole.Instance.Output (" ");
					SdtdConsole.Instance.Output (GetHelp ());
					return;
				}

				Vector3 pos = new Vector3 ();
				int x = int.MinValue;
				int y = int.MinValue;
				int z = int.MinValue;

				if (_params.Count == 1) {
					ClientInfo ci1 = ConsoleHelper.ParseParamIdOrName (_params [0]);
					if (ci1 == null) {
						SdtdConsole.Instance.Output ("Playername or entity/steam id not found.");
						return;
					}
					EntityPlayer ep1 = GameManager.Instance.World.Players.dict [ci1.entityId];
					pos = ep1.GetPosition ();
				} else if (_params.Count == 3) {
					int.TryParse (_params [0], out x);
					int.TryParse (_params [1], out y);
					int.TryParse (_params [2], out z);

					if (x == int.MinValue || y == int.MinValue || z == int.MinValue) {
						SdtdConsole.Instance.Output ("x:" + x);
						SdtdConsole.Instance.Output ("y:" + y);
						SdtdConsole.Instance.Output ("z:" + z);
						SdtdConsole.Instance.Output ("At least one of the given coordinates is not a valid integer");
						return;
					}

					pos = new Vector3 ((float)x, (float)y, (float)z);
				}
                
				AIDirectorChunkEventComponent chunkComponent = GameManager.Instance.World.aiDirector.GetComponent<AIDirectorChunkEventComponent> ();
				if (chunkComponent == null) {
					SdtdConsole.Instance.Output ("No AIDirectorChunkEventComponent Component found");
					return;
				}

				chunkComponent.CreateHorde (pos);
				SdtdConsole.Instance.Output ("Horde spawning at " + pos.x + ", " + pos.y + ", " + pos.z);

			} catch (Exception e) {
				Log.Out ("Error in SpawnHorde: " + e);
			}
		}
	}
}
