using System;
using AllocsFixes.PersistentData;

namespace CoppisAdditions
{
	public class ChatFilter
	{

		public static bool Exec (ClientInfo _cInfo, EnumGameMessages _type, string _message, string _playerName)
		{
			if (_type == EnumGameMessages.Chat && !string.IsNullOrEmpty (_message)) {
				if (_cInfo != null) {
					Player p = PersistentContainer.Instance.Players [_cInfo.playerId, false];
					if (p != null) {
						if (_message.Length > p.MaxChatLength) {
							_cInfo.SendPackage (new NetPackageGameMessage (EnumGameMessages.Chat, "Your message was too long. So we blocked it!", "Server (PM)", false, "", false));
							return false;
						}
						if (p.IsChatMuted) {
							_cInfo.SendPackage (new NetPackageGameMessage (EnumGameMessages.Chat, "Your chat is muted!", "Server (PM)", false, "", false));
							return false;
						}

						//Check its a command
						if (PersistentContainer.Instance.Attributes.HideChatCommands) {
							if (_message.Trim ().StartsWith (PersistentContainer.Instance.Attributes.HideChatCommandPrefix)) {
								_cInfo.SendPackage (new NetPackageGameMessage (EnumGameMessages.Chat, "Command received " + _message, "Server (PM)", false, "", false));
								Log.Out ("Chat command from '" + p.Name + "': " + _message);
								return false;
							}
						}
					}
				} else {
//					Log.Error ("ChatFilter: Argument _cInfo null on message: {0}", _message);
				}
			}

			return true;
		}

	}
}
