using System;
using System.Collections.Generic;

namespace AllocsFixes.CustomCommands
{
	public class webstat : ConsoleCmdAbstract
	{
		public override string GetDescription ()
		{
			return "DEBUG PURPOSES ONLY";
		}

		public override string[] GetCommands ()
		{
			return new string[] { "webstat" };
		}

		public override void Execute (List<string> _params, CommandSenderInfo _senderInfo)
		{
			try {
				int curHandlers = AllocsFixes.NetConnections.Servers.Web.Web.currentHandlers;
				int totalHandlers = AllocsFixes.NetConnections.Servers.Web.Web.handlingCount;
				long totalTime = AllocsFixes.NetConnections.Servers.Web.Web.totalHandlingTime;
				SdtdConsole.Instance.Output ("Current Web handlers: " + curHandlers + " - total: " + totalHandlers);
				SdtdConsole.Instance.Output (" - Total time: " + totalTime + " µs - average time: " + (totalTime / totalHandlers) + " µs");

				curHandlers = AllocsFixes.NetConnections.Servers.Web.WebCommandResult.currentHandlers;
				totalHandlers = AllocsFixes.NetConnections.Servers.Web.WebCommandResult.handlingCount;
				totalTime = AllocsFixes.NetConnections.Servers.Web.WebCommandResult.totalHandlingTime;
				SdtdConsole.Instance.Output ("Current Web command handlers: " + curHandlers + " - total: " + totalHandlers);
				SdtdConsole.Instance.Output (" - Total time: " + totalTime + " µs" + (totalHandlers > 0 ? " - average time: " + (totalTime / totalHandlers) + " µs" : ""));
			} catch (Exception e) {
				Log.Out ("Error in webstat.Run: " + e);
			}
		}
	}
}
