using System;
using System.Net;

namespace AllocsFixes.NetConnections.Servers.Web.Handlers
{
	public abstract class PathHandler
	{
		private string moduleName = null;
		public string ModuleName {
			get { return moduleName; }
		}

		protected PathHandler (string _moduleName, int _defaultPermissionLevel = 0) {
			this.moduleName = _moduleName;
			WebPermissions.Instance.AddKnownModule (_moduleName, _defaultPermissionLevel);
		}

		public abstract void HandleRequest (HttpListenerRequest req, HttpListenerResponse resp, WebConnection user, int permissionLevel);

		public bool IsAuthorizedForHandler (WebConnection user, int permissionLevel) {
			if (moduleName != null) {
				return WebPermissions.Instance.ModuleAllowedWithLevel (moduleName, permissionLevel);
			} else {
				return true;
			}
		}
	}
}

