using AllocsFixes.JSON;
using AllocsFixes.PersistentData;
using System;
using System.Collections.Generic;
using System.Net;

namespace AllocsFixes.NetConnections.Servers.Web.API
{
	public class GetAllowedCommands : WebAPI {
		public override void HandleRequest (HttpListenerRequest req, HttpListenerResponse resp, WebConnection user, int permissionLevel) {
			JSONObject result = new JSONObject ();
			JSONArray entries = new JSONArray ();
			foreach (IConsoleCommand cc in SdtdConsole.Instance.GetCommands ()) {
				AdminToolsCommandPermissions atcp = GameManager.Instance.adminTools.GetAdminToolsCommandPermission (cc.GetCommands ());
				if (permissionLevel <= atcp.PermissionLevel) {
					string cmd = string.Empty;
					foreach (string s in cc.GetCommands ()) {
						if (s.Length > cmd.Length) {
							cmd = s;
						}
					}
					JSONObject cmdObj = new JSONObject ();
					cmdObj.Add ("command", new JSONString (cmd));
					cmdObj.Add ("description", new JSONString (cc.GetDescription ()));
					cmdObj.Add ("help", new JSONString (cc.GetHelp ()));
					entries.Add (cmdObj);
				}
			}

			result.Add ("commands", entries);

			WriteJSON (resp, result);
		}

		public override int DefaultPermissionLevel () {
			return 2000;
		}
	}
}

