using System;
using System.Collections.Generic;
using System.Reflection;

namespace CoppisAdditions.CustomCommands
{
	public class ListPlayersFriends : ConsoleCmdAbstract
	{
		public override string GetDescription ()
		{
			return "list friends of a single player or all players";
		}

		public override string GetHelp ()
		{
			return "Usage:\n" +
			"  1. lpf <steam id / player name / entity id>" +
			"  2. lpf (to list all players friends)";
		}

		public override string[] GetCommands ()
		{
			return new string[] { "listplayerfriends", "lpf" };
		}

		public override void Execute (List<string> _params, CommandSenderInfo _senderInfo)
		{
			try {
				if (_params.Count > 1) {
					SdtdConsole.Instance.Output ("Usage: listplayerfriends <entityid|playername|steamid> or listplayerfriends");
				} else {
					if (_params.Count == 0) {
						foreach (string steamid in GameManager.Instance.persistentPlayers.Players.Keys) {
							PrintFriendsOfPlayer (steamid);
						}
					} else {
						string steamid = null;

						ClientInfo ci = ConsoleHelper.ParseParamIdOrName (_params [0]);
						if (ci != null) {
							steamid = ci.playerId;
						}

						if (steamid == null) {
							if (ConsoleHelper.ParseParamSteamIdValid (_params [0])) {
								steamid = _params [0];
							}
						}

						if (steamid == null) {
							SdtdConsole.Instance.Output ("Playername or entity/steamid id not found.");
							return;
						}

						PrintFriendsOfPlayer (steamid);
					}
				}
			} catch (Exception e) {
				Log.Out ("Error in ListPlayersFriends.Run: " + e);
			}
		}

		private void PrintFriendsOfPlayer (string _steamid) {
			PersistentPlayerData data = GameManager.Instance.persistentPlayers.GetPlayerData (_steamid);
			string friends = "";
			if (data != null && data.ACL != null) {
				foreach (string friend in data.ACL) {
					if (!string.IsNullOrEmpty (friend)) {
						if (!friends.Equals ("")) {
							friends += ",";
						}
						friends += friend;
					}
				}
			}
			SdtdConsole.Instance.Output ("FriendsOf id=" + _steamid + ", friends=" + friends);
		}

	}
}
