using AllocsFixes.JSON;
using AllocsFixes.LiveData;
using AllocsFixes.PersistentData;
using System;
using System.Collections.Generic;
using System.Net;

namespace AllocsFixes.NetConnections.Servers.Web.API
{
	public class GetWebUIUpdates : WebAPI {
		public override void HandleRequest (HttpListenerRequest req, HttpListenerResponse resp, WebConnection user, int permissionLevel) {
			int latestLine;
			if (req.QueryString ["latestLine"] == null || !int.TryParse (req.QueryString ["latestLine"], out latestLine)) {
				latestLine = 0;
			}

			JSONObject result = new JSONObject ();

			JSONObject time = new JSONObject ();
			time.Add ("days", new JSONNumber (GameUtils.WorldTimeToDays (GameManager.Instance.World.worldTime)));
			time.Add ("hours", new JSONNumber (GameUtils.WorldTimeToHours (GameManager.Instance.World.worldTime)));
			time.Add ("minutes", new JSONNumber (GameUtils.WorldTimeToMinutes (GameManager.Instance.World.worldTime)));
			result.Add ("gametime", time);

			result.Add ("players", new JSONNumber (GameManager.Instance.World.Players.Count));
			result.Add ("hostiles", new JSONNumber (Hostiles.GetCount ()));
			result.Add ("animals", new JSONNumber (Animals.GetCount ()));

			result.Add ("newlogs", new JSONNumber (LogBuffer.Instance.LatestLine - latestLine));

			WriteJSON (resp, result);
		}

		public override int DefaultPermissionLevel () {
			return 2000;
		}
	}
}

