﻿using System;
using System.Collections.Generic;

namespace AllocsFixes.LiveData
{
	public class Hostiles
	{
		public static void Get (List<EntityEnemy> _list) {
			_list.Clear ();
			try {
				List<Entity> entities = GameManager.Instance.World.Entities.list;
				for (int i = 0; i < entities.Count; i++) {
					Entity entity = entities [i];

					if (entity is EntityEnemy) {
						if (entity.IsAlive ())
							_list.Add (entity as EntityEnemy);
					}
				}
			}
			catch (Exception e) {
				Log.Exception (e);
			}
		}

		public static int GetCount () {
			int count = 0;
			try {
				List<Entity> entities = GameManager.Instance.World.Entities.list;
				for (int i = 0; i < entities.Count; i++) {
					Entity entity = entities [i];

					if (entity.entityType == EntityType.Zombie) {
						EntityEnemy ee = (EntityEnemy)entity;

						if (ee.IsAlive ())
							count++;
					}
				}
			}
			catch (Exception e) {
				Log.Exception (e);
			}
			return count;
		}
	}
}

