﻿using System;
using System.Collections.Generic;

namespace AllocsFixes.LiveData
{
    public class Animals
    {
		public static void Get (List<EntityAnimal> _list) {
			_list.Clear ();
			try {
				List<Entity> entities = GameManager.Instance.World.Entities.list;
				for (int i = 0; i < entities.Count; i++) {
					Entity entity = entities [i];

					if (entity is EntityAnimal) {
						EntityAnimal ea = (EntityAnimal)entity;

						if (ea.IsAlive ())
							_list.Add (ea);
					}
				}
			}
			catch (Exception e) {
				Log.Exception (e);
			}
		}

		public static int GetCount () {
			int count = 0;
			try {
				List<Entity> entities = GameManager.Instance.World.Entities.list;
				for (int i = 0; i < entities.Count; i++) {
					Entity entity = entities [i];

					if (entity is EntityAnimal) {
						EntityAnimal ea = (EntityAnimal)entity;

						if (ea.IsAlive ())
							count++;
					}
				}
			}
			catch (Exception e) {
				Log.Exception (e);
			}
			return count;
		}

    }
}

